<?php
// ++=========================================================================++
// || vBadvanced Links Directory v1.0.0 RC3                                   
// ||  2003-2004 vBadvanced.com & PlurPlanet, LLC - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// || =-=-=-=+_++_+_+_+_+_+_+_+__+_+_++_+_+__+_+_+_+_++_+_+_+_+_+_+_+_=-=-=-=-=-
// || You are downloading a Ripped/Scripts that is not made by http://club2share.com staff.
// || Anything that happen because of running the Ripped/Scripts is not a responsibility of
// || clubshare staff. Downloading and opening the Ripped/Scripts is at your own risk.  Thank
// ||  you very much!  
// ||----------------------------------------------------------------------------
// ||Ripped By : Vb_IPB_RIP Member Of Club2Share
// ||Download  : Club2Share.Com
// ||Price     : $34.99
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);
define('NO_REGISTER_GLOBALS', 1);

// ###################### Global Stuff #########################
$directoryopts = array(
	'open_for_links' => 1,
	'open_for_posts' => 2,
	'allow_post_html' => 4,
	'allow_post_bbcode' => 8,
	'allow_post_smilies' => 16,
	'allow_post_icons' => 32,
	'allow_post_bbimgcode' => 64,
	'allow_post_icons' => 128,
	'allow_custom_html' => 256,
	'allow_custom_bbcode' => 512,
	'allow_custom_smilies' => 1024,
	'allow_custom_icons' => 2048,
	'allow_custom_bbimgcode' => 4096
);

// ###################### Function to Construct Categories #####################
function construct_directories($catinfo, $cat = 0, $stoplevel = 1)
{
	global $counter;

	if ($catinfo)
	{
		$catarray = array();
		foreach ($catinfo AS $cats)
		{
			if ($cats['parent'] == $cat)
			{
				$counter++;
				$cats['level'] = $counter;
				if (!$cats['haslinks'] AND $stoplevel != '-1')
				{
					$stopat = $stoplevel + 1;
				}
				if ($subcat = construct_directories($catinfo, $cats['catid'], $stoplevel))
				{
					foreach ($subcat AS $subs)
					{
						$cats['linkcount'] += $subs['linkcount'];
						$cats['postcount'] += $subs['postcount'];
	
						if ($subs['lastupdated'] > $cats['lastupdated'])
						{
							$cats['lastupdated'] = $subs['lastupdated'];
							$cats['lastlinkid'] = $subs['lastlinkid'];
							$cats['lastposter'] = $subs['lastposter'];
							$cats['lastuserid'] = $subs['lastuserid'];
							$cats['lastlinktitle'] = $subs['lastlinktitle'];
						}
					}
					$catarray[] = $cats;
					if ($cats['level'] < intval($stopat) OR $stoplevel == -1)
					{
						$catarray = array_merge($catarray, $subcat);
					}
				}
				else
				{
					$catarray[] = $cats;
				}
				$counter--;
			}
		}
	}
	return $catarray;
}

// ################### Function to Print Categories ########################
function print_directories($cat = 0, $catinfo = '', $subscriptions = false)
{
	global $DB_site, $permissions, $vboptions, $vba_options, $vbcollapse, $bbuserinfo, $stylevar, $vbphrase, $show;

	if (!is_array($catinfo))
	{
		$catinfo = array();
		$getcats = $DB_site->query("
				SELECT catid, title, description, parent, haslinks, parentlist, private
				" . iif(($permissions['linkspermissions'] & CANVIEWLINKS), ', linkcount, postcount, lastlinkid, lastlinktitle, lastposter, lastuserid, lastupdated') . "
				FROM " . TABLE_PREFIX ."links_categories
				ORDER BY displayorder ASC, haslinks
		");
		while ($categories = $DB_site->fetch_array($getcats))
		{
			$catinfo[] = $categories;
		}
	
		$DB_site->free_result($getcats);
		unset($categories);
	}

	if ($subscriptions OR $catinfo = construct_directories($catinfo, $cat, 1))
	{
		$links_modcache = cache_links_mods();
		foreach ($catinfo AS $cats)
		{
			if ($cats['private'] AND !($permissions['linkspermissions'] & CANVIEWPRIVATE))
			{
				continue;
			}

			$cats['title'] = stripslashes($cats['title']);
			$cats['description'] = stripslashes($cats['description']);

			if ($cats['haslinks'] == 1)
			{
				if ($show['modcolumn'])
				{
					foreach (explode(',', $cats['parentlist']) AS $parentid)
					{
						if ($links_modcache[$parentid])
						{
							foreach ($links_modcache[$parentid] AS $moderator)
							{
								if (!$donemods[$cats['catid']][$moderator['userid']])
								{								
									$donemods[$cats['catid']][$moderator['userid']] = true;

									$comma = '';
									if (!empty($cats['moderator']))
									{
										$comma = ', ';
									}
	
									eval('$cats[\'moderator\'] .= "$comma' . fetch_template('forumhome_moderator') . '";');
									$cats['moderator'] = str_replace('"member.php', "\"$vboptions[bburl]/member.php", $cats['moderator']);
								}
							}
						}
					}
				}
				$cats['linkcount'] = number_format($cats['linkcount']);
				$cats['postcount'] = number_format($cats['postcount']);

				if ($bbuserinfo['lastvisit'] < $cats['lastupdated'])
				{
					$onoff = 'new';
				}
				else
				{
					$onoff = 'old';
				}

				if ($cats['lastupdated'])
				{
					$cats['lastupdateddate'] = vbdate($vboptions['dateformat'], $cats['lastupdated']);
					$cats['lastupdatedtime'] = vbdate($vboptions['timeformat'], $cats['lastupdated']);
					$cats['lastposter'] = stripslashes($cats['lastposter']);
					$cats['lastlinktitle'] = fetch_trimmed_title(stripslashes($cats['lastlinktitle']), $vba_options['links_lastlink_maxlength']);
				}
				eval('$directorybits .= "' . fetch_template('adv_links_directorybit') . '";');
			}
			else
			{
				$catcollapse = $vbcollapse["collapseobj_dirbit_" . $cats['catid'] . ""];
				eval('$directorybits .= "' . fetch_template('adv_links_directorybit_main') . '";');
			}
		}
		unset($catinfo, $cats);
	}

	return $directorybits;
}

// ############################ Cache Moderators ############################
function cache_links_mods()
{
	global $datastore;

	if ($linkmods = unserialize($datastore['links_mod_cache']))
	{
		foreach ($linkmods AS $moderator)
		{
			$moderator['musername'] = fetch_musername($moderator);
			$links_modcache[$moderator['catid']][$moderator['userid']] = $moderator;
		}
	}
	return $links_modcache;
}

// ########################### Delete Links #############################
function delete_links($linkarray)
{
	global $DB_site;
	if (is_array($linkarray))
	{
		$dellinks = implode(',', $linkarray);
	}
	else
	{
		$dellinks = $linkarray;
	}
	$DB_site->query("DELETE FROM " . TABLE_PREFIX . "links WHERE linkid IN ($dellinks)");
	$DB_site->query("DELETE FROM " . TABLE_PREFIX . "links_posts WHERE linkid IN ($dellinks)");
	$DB_site->query("DELETE FROM " . TABLE_PREFIX . "links_favorites WHERE linkid IN ($dellinks)");
	$DB_site->query("DELETE FROM " . TABLE_PREFIX . "links_subscribelink WHERE linkid IN ($dellinks)");
	$DB_site->query("DELETE FROM " . TABLE_PREFIX . "links_customfields_entries WHERE lid IN ($dellinks)");
}

// ###################### Construct Orderby #######################
function construct_orderby()
{
	global $orderby, $vba_options, $direction;
	switch($orderby) 
	{
		case 'name':
			break;
		case 'dateline':
			break;
		case 'directory':
			$doorderby = 'links_categories.title';
			break;
		case 'lastpostdateline':
			break;
		case 'linkid':
			break;
		case 'posts':
			break;
		case 'rating':
			$doorderby = 'voteavg ' . $direction . ', votenum';
			break;
		case 'views':
			break;
		default:
			$doorderby = $vba_options['links_deforder'];
	}
	if (!$doorderby)
	{
		$doorderby = $orderby;
	}
	return $doorderby;
}

// ######################### Find Directory Mods #########################
function is_directory_mod($catarray)
{
	global $bbuserinfo, $permissions;

	if ($permissions['adminpermissions'] & CANCONTROLPANEL)
	{
		$ismoderator = true;
	}
	else
	{
		$links_modcache = cache_links_mods();
	
		foreach (explode(',', $catarray) AS $parentid)
		{
			if ($links_modcache[$parentid])
			{
				foreach($links_modcache[$parentid] AS $moderator)
				{
					if ($bbuserinfo['userid'] == $moderator['userid'])
					{
						$ismoderator = true;
					}
				}
			}
		}
	}
	return $ismoderator;
}	

// #################### Check Link ID ##########################
function check_link_id($linkid)
{
	global $vbphrase;

	if (!$linkid)
	{
		$idname = $vbphrase['link'];
		eval(print_standard_error('error_noid'));
	}
}

// ########################## Highlight Keywords #########################
function highlight_keywords($string, $keywords, $wholeword)
{
	if ($keywords)
	{
		$words = explode(' ', $keywords);
		
		foreach ($words as $word)
		{
			if ($wholeword)
			{
				$word = ' ' . $word . ' ';
			}
			$position = 0;
			
			while ($position !== false)
			{
				$position = strpos(strtolower($string), strtolower($word), $position);
				
				if ($position !== false)
				{
					$replace_string = substr($string, $position, strlen($word));
					
					$replace_string = '<span class="highlight">' . $replace_string . '</span>';
					
					$string = substr_replace($string, $replace_string, $position, strlen($word));
					
					$position = $position + strlen($replace_string);
				}		
			}
		}
	}
	return $string;
}

// #################### Construct Linkbit ######################
function construct_linkbits($link, $highlight = '')
{
	global $vboptions, $vba_options, $stylevar, $bbuserinfo, $vbphrase, $returnto, $show, $adv_sorturl, $catid;

	$link['name'] = stripslashes($link['name']);
	$link['description'] = stripslashes($link['description']);
	$link['username'] = stripslashes($link['username']);
	$link['updatedate'] = vbdate($vboptions['dateformat'], $link['dateline']);
	$link['updatetime'] = vbdate($vboptions['timeformat'], $link['dateline']);
	$link['category'] = stripslashes($link['title']);
	$link['replies'] = number_format($link['posts']);
	$link['views'] = number_format($link['views']);
	$link['lastpostdate'] = vbdate($vboptions['dateformat'], $link['lastpostdateline']);
	$link['lastposttime'] = vbdate($vboptions['timeformat'], $link['lastpostdateline']);
	$link['lastpostusername'] = stripslashes($link['lastpostusername']);

	if ($highlight)
	{
		$sfields = explode(',', $highlight['fields']);

		if (in_array('description', $sfields))
		{
			$link['description'] = highlight_keywords($link['description'], $highlight['string'], $highlight['wholeword']);
		}
		if (in_array('name', $sfields))
		{
			$link['name'] = highlight_keywords($link['name'], $highlight['string'], $highlight['wholeword']);
		}				
	}

	if (!$link['open'])
	{
		$link['folder'] = 'thread_lock';
	}
	elseif (($bbuserinfo['lastvisit'] < $link['dateline'] OR $bbuserinfo['lastvisit'] < $link['lastpostdateline']) AND ($link['views'] >= $vba_options['links_hotviews'] OR $links['posts'] >= $vba_options['links_hotposts']) AND ($vba_options['links_hotviews'] OR $vba_options['links_hotposts']))
	{
		$link['folder'] = 'thread_hot_new';
	}
	elseif (($bbuserinfo['lastvisit'] < $link['dateline'] OR $bbuserinfo['lastvisit'] < $link['lastpostdateline']) AND $link['views'] < $vba_options['links_hotviews'])
	{
		$link['folder'] = 'thread_new';
	}
	elseif (($link['views'] >= $vba_options['links_hotviews'] OR $link['posts'] >= $vba_options['links_hotposts']) AND ($vba_options['links_hotviews'] OR $vba_options['links_hotposts']))
	{
		$link['folder'] = 'thread_hot';
	}
	else
	{
		$link['folder'] = 'thread';
	}

	$show['sticky'] = false;
	if ($link['sticky'])
	{
		$show['sticky'] = true;
	}

	$show['subscribed'] = false;
	if ($link['subid'])
	{
		$show['subscribed'] = true;
	}

	$show['link_rating'] = false;
	if ($link['votetotal'] AND $link['votenum'] AND $show['ratelink'])
	{
		$link['truerating'] = number_format($link['votetotal'] / $link['votenum'], 2);
		$link['roundrating'] = round($link['truerating']);
		$show['link_rating'] = true;
	}

	eval('$linkbits .= "' . fetch_template('adv_links_linkbit') . '";');
	return $linkbits;
}

// ##################### Construct Navbar #################################
if (!function_exists('construct_adv_navbar'))
{
	function construct_adv_navbar($navbits, $index = 'false')
	{
		global $vboptions, $vba_options, $vbphrase, $stylevar, $bbuserinfo, $show, $pmbox;

		if (!empty($navbits))
		{
			$navbits = construct_navbits($navbits);
		}
		eval('$navbar = "' . fetch_template('navbar') . '";');
	
		$navbar = str_replace(
		array(
			'"memberlist.php',
			'"usercp.php',
			'"register.php',
			'"faq.php',
			'"calendar.php',
			'"search.php',
			'"login.php',
			'"forumdisplay.php',
			'"profile.php',
			'"private.php',
			'"subscription.php',
			'"member.php',
			'"online.php',
			'"clientscript',
			'\'misc.php',
			$vboptions['bbtitle'],
			'"' . $vboptions['forumhome'] . '.php'
		), 
		array(
			'"' . $vboptions['bburl'] . '/memberlist.php',
			'"' . $vboptions['bburl'] . '/usercp.php',
			'"' . $vboptions['bburl'] . '/register.php',
			'"' . $vboptions['bburl'] . '/faq.php',
			'"' . $vboptions['bburl'] . '/calendar.php',
			'"' . $vboptions['bburl'] . '/search.php',
			'"' . $vboptions['bburl'] . '/login.php',
			'"' . $vboptions['bburl'] . '/forumdisplay.php',
			'"' . $vboptions['bburl'] . '/profile.php',
			'"' . $vboptions['bburl'] . '/private.php',
			'"' . $vboptions['bburl'] . '/subscription.php',
			'"' . $vboptions['bburl'] . '/member.php',
			'"' . $vboptions['bburl'] . '/online.php',
			'"' . $vboptions['bburl'] . '/clientscript',
			'\'' . $vboptions['bburl'] . '/misc.php',
			iif($vba_options['links_navbarhomelink'], $vboptions['hometitle'], $vba_options['links_title']),
			'"' . iif($vba_options['links_navbarhomelink'], $vboptions['homeurl'], $vba_options['links_homeurl'])
		), $navbar);
		return $navbar;
	}
}

// ############################## Update Directory Cache ######################
function update_directory_cache()
{
	global $DB_site;

	$catinfo = array();

	$getcats = $DB_site->query("SELECT catid, title, parent, haslinks, private, options FROM " . TABLE_PREFIX . "links_categories ORDER BY displayorder ASC, haslinks");
	while ($categories = $DB_site->fetch_array($getcats))
	{
		$catinfo[] = $categories;
	}

	$DB_site->free_result($getcats);
	build_datastore('links_d_cache', serialize($catinfo));
	unset($categories, $catinfo, $mcats);
}

// ########################### Make Cat Select Field #########################
function print_dir_select($selectedid = 0, $disablemaincats = true, $hideclosed = false)
{
	global $DB_site, $datastore, $permissions;

	if (empty($datastore['links_d_cache']))
	{
		update_directory_cache();
	}		

	if ($catinfo = construct_directories(unserialize($datastore['links_d_cache']), 0, -1))
	{
		foreach ($catinfo as $cats)
		{
			if ($cats['private'] AND !($permissions['linkspermissions'] & CANVIEWPRIVATE))
			{
				continue;
			}

			$title = stripslashes($cats['title']);
	    $dashes = str_repeat(' &nbsp; &nbsp; ', $cats['level'] - 1);
			$selected = '';
			if ($selectedid == $cats['catid'])
			{
				$selected = 'selected="selected"';
				$class = 'fjsel';
			}
			elseif ($cats['level'] <= 4)
			{
				$class = 'fjdpth' . $cats['level'];
			}
			else
			{
				$class = 'fjdpth';
			}
			if (!$cats['haslinks'] AND $disablemaincats)
			{
				if ($options)
				{
					$endgroup = true;
					$options .= '</optgroup>';
				}
				$options .= '<optgroup label="&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $dashes . '' . $title . '">';
			}
			else
			{
				if ($hideclosed)
				{
					$diropts = construct_dir_opts($cats['catid'], $cats['options']);
					if (!$diropts['open_for_links'])
					{
						continue;
					}
				}
				$options .= '<option class="' . $class . '" value="' . $cats['catid'] . '" ' . $selected . '>' . $dashes . '' . $title . '</option>';
			}
		}
		if ($endgroup)
		{
			$options .= '</optgroup>';
		}
		unset($cats, $catinfo);
	}
	return $options;
}

// ####################### Construct Private Directories #######################
function fetch_private_directories()
{
	global $datastore;
	if ($catinfo = unserialize($datastore['links_d_cache']))
	{
		$privcatids = array();
		foreach ($catinfo as $cats)
		{
			if ($cats['private'])
			{
				$privcatids[] = $cats['catid'];
			}
		}
	$privcats = implode(',', $privcatids);
	}
	return $privcats;
}

// ########################### Find Private Directories #######################
function check_directory_permissions($dirid)
{
	global $permissions, $vbphrase;
	if (!($permissions['linkspermissions'] & CANVIEWPRIVATE))
	{
		$privcats = fetch_private_directories();

		if (in_array($dirid, array($privcats)))
		{
			print_adv_no_permission();
		}
	}
}

// ############################ Directory Jump #################################
function print_directory_jump($dcatid = 0)
{
	global $catid, $vba_options, $_REQUEST, $vbphrase, $stylevar, $gobutton;

	if ($vba_options['links_enable_dirjump'])
	{
		switch ($_REQUEST['do'])
		{
			case 'favorites':
				break;
			case 'subscriptions':
				break;
			case 'newlinks':
				break;
			case 'poplinks':
				break;
			case 'search':
				break;
		}
	
		$action = $_REQUEST['do'];
	
		$doselect[$_REQUEST['do']] = 'class="fjsel" selected="selected"';
	
		$options = print_dir_select($dcatid, false);
	
		eval('$directoryjump = "' . fetch_template('adv_links_directoryjump') . '";');
		
		return $directoryjump;
	}
}

// ################# Construct the navbits for browselinks ######################
function construct_dir_navbits($parentlist)
{
	global $datastore, $vboptions, $navbits;

	foreach (array_reverse(explode(',', $parentlist)) AS $key => $parent)
	{
		foreach (unserialize($datastore['links_d_cache']) AS $cats)
		{
			if ($parent == $cats['catid'])
			{
				$navbits["browselinks.php?$session[sessionurl]c=$cats[catid]"] = stripslashes($cats['title']);
			}
		}
	}
	unset($dircache, $parentlist);
	return $navbits;
}

// ########## Adv Sorting URL (used for sorting on showlink.php ###############
function construct_adv_sort_url($extra = '')
{
	global $_REQUEST;

	if ($_REQUEST['c'])
	{
		$_REQUEST['catid'] = $_REQUEST['c'];
	}

	if (in_array($_REQUEST['do'], array('favorites', 'poplinks', 'newlinks', 'subscriptions', 'member')))
	{
		$adv_sorturl = '&amp;catid=' . $_REQUEST['do'];
	}
	elseif ($_REQUEST['do'] == 'searchresults')
	{
		if ($extra)
		{
			$_REQUEST['searchid'] = $extra;
		}
		$adv_sorturl = '&amp;catid=searchresults';
	}
	else
	{
		$adv_sorturl = '&amp;catid=' . $_REQUEST['catid'];
	}

	if ($_REQUEST['orderby'])
	{
		$adv_sorturl .= '&amp;orderby=' . $_REQUEST['orderby'];
	}
	if ($_REQUEST['direction'])
	{
		$adv_sorturl .= '&amp;direction=' . $_REQUEST['direction'];
	}
	if (!empty($_REQUEST['linkuserid']))
	{
		$adv_sorturl .= '&amp;linkuserid=' . $_REQUEST['linkuserid'];
	}
	if ($_REQUEST['searchid'])
	{
		$adv_sorturl .= '&amp;searchid=' . $_REQUEST['searchid'];
	}

	return $adv_sorturl;
}

// ###################### Initial Update Counters Function ##################
function update_count($catid = 0, $linkcounters = true, $postcounters = true, $llcounters = true)
{
	global $DB_site;

	if ($catid)
	{
		$catquery = "WHERE catid = '$catid'";
	}

	$getdirs = $DB_site->query("SELECT catid FROM " . TABLE_PREFIX . "links_categories $catquery ORDER BY displayorder ASC, haslinks");
	while ($dirs = $DB_site->fetch_array($getdirs))
	{
		if ($llcounters)
		{
			$llfields = ', name, dateline, username, userid';
		}

		$linkids = array();

		$getlinks = $DB_site->query("SELECT linkid $llfields FROM " . TABLE_PREFIX . "links WHERE catid = '$dirs[catid]' AND suspended = 0 AND valid = 1 ORDER BY dateline DESC");
		$linkcount = $DB_site->num_rows($getlinks);
		$counter = 0;
		while ($links = $DB_site->fetch_array($getlinks))
		{
			$counter++;
			if ($counter == 1 AND $llcounters)
			{
				$dirs['lastlinkid'] = $links['linkid'];
				$dirs['lastlinkdate'] = $links['dateline'];
				$dirs['lastlinkuser'] = $links['username'];
				$dirs['lastlinkname'] = $links['name'];
				$dirs['lastlinkuserid'] = $links['userid'];
			}
			$linksids[] = $links['linkid'];		
		}
		$DB_site->free_result($getlinks);
		unset($links);

		$dirs['linkcount'] = $linkcount;

		if (!empty($linksids) AND $postcounters)
		{
			$linkids = implode(',', $linksids);
			$postids = array();

			$getposts = $DB_site->query("SELECT postid FROM " . TABLE_PREFIX . "links_posts WHERE linkid IN ($linkids) AND visible = 1");
			$postcount = $DB_site->num_rows($getposts);
			while ($posts = $DB_site->fetch_array($getposts))
			{
				$postids[] = $posts['postid'];
			}
			$dirs['pcount'] = $postcount;
			unset($linkids, $linksids);
		}
		else
		{
			$dirs['pcount'] = 0;
		}

		$DB_site->query("UPDATE " . TABLE_PREFIX . "links_categories SET " . iif($linkcounters, "linkcount = '$dirs[linkcount]'") . "" . iif($postcounters, "" . iif($linkcounters, ',') . "postcount = '$dirs[pcount]' ") . " " . iif($llcounters, "" . iif($postcounters OR $linkcounters, ',') . "lastlinkid = '$dirs[lastlinkid]', lastupdated = '$dirs[lastlinkdate]', lastlinktitle = '" . addslashes($dirs['lastlinkname']) . "', lastposter = '$dirs[lastlinkuser]', lastuserid = '$dirs[lastlinkuserid]'") . " WHERE catid = '$dirs[catid]' AND haslinks = 1");
	}
}

// ############### Rebuild Directory Info (Update Counters) ######################
function rebuild_dir_info($dirinfo, $cat = 0)
{
	global $DB_site, $donearray;

	if (empty($donearray))
	{
		$donearray = array();
	}

	foreach ($dirinfo AS $info => $dirs)
	{
		if (($dirs['parent'] == $cat OR $dirs['catid'] == $cat) AND !in_array($dirs['catid'], $donearray))
		{
			$donearray[] = $dirs['catid'];

			if ($subcat = rebuild_dir_info($dirinfo, $dirs['catid']))
			{
				$directoryarray = array_merge($directoryarray, $subcat);
			}

			$directoryarray[] = $dirs;
		}
	}
	return $directoryarray;
}

// ##################### No Permission Page #######################
if (!function_exists('print_adv_no_permission'))
{
	function print_adv_no_permission()
	{
		global $header, $footer, $headinclude, $vboptions, $vbphrase, $bbuserinfo, $stylevar, $url, $session;
	
		if ($bbuserinfo['userid'])
		{
			eval('$errormessage = "' . fetch_phrase('nopermission_loggedin', PHRASETYPEID_ERROR) . '";');
		}
		else
		{
			$logincode = construct_login_code();
			$scriptpath = htmlspecialchars_uni(SCRIPTPATH);
			$show['permission_error'] = true;
		}
		eval('$content = "' . fetch_template('STANDARD_ERROR') . '";');
	
		$content = str_replace(
			array(
				'"register.php',
				'"login.php'
			),
			array(
				'"' . $vboptions['bburl'] . '/register.php',
				'"' . $vboptions['bburl'] . '/login.php'
			),
			$content
		);
	
		eval(print_output($content));
		exit;
	}
}

// ######################### Create Custom Fields #######################
function construct_custom_fieldbits($linkinfo, $custominfo = '', $editing = false, $admin = false, $makearray = false)
{
	global $DB_site, $vbphrase;

	if (empty($custominfo))
	{
		$custominfo = array();
		$customfields = $DB_site->query("SELECT * FROM " . TABLE_PREFIX . "links_customfields ORDER BY displayorder");
		while ($field = $DB_site->fetch_array($customfields))
		{
			$custominfo[] = $field;
		}
		$DB_site->free_result($customfields);
		unset($field);
	}
	
	if (!empty($custominfo))
	{
		foreach ($custominfo AS $field)
		{
			$fieldname = 'field' . $field['fieldid'];
			$fieldid = 'field' . $field['fieldid'] . iif($makearray, '[' . $linkinfo['linkid'] . ']');
			if ($field['options'])
			{
				$field['options'] = explode("\n", $field['options']);
			}
	
			switch($field['type'])
			{
				case 'textarea':
					$inputbox = '<textarea class="bginput" cols="40" name="' . $fieldid . '" rows="6">' . htmlspecialchars($linkinfo["$fieldname"]) . '</textarea>';
					break;
	
				case 'select':
					$linkinfo["$fieldname"] = htmlspecialchars($linkinfo["$fieldname"]);
					$inputbox = '<select name="' . $fieldid . '">';
					$inputbox .= '<option value="">' . $vbphrase['please_select_one'] . '</option>';
					foreach ($field['options'] AS $option)
					{
						$inputbox .= '<option ' . iif($linkinfo["$fieldname"] == $option, 'selected="selected"') . ' value="' . $option . '">' . $option . '</option>';
					}
					$inputbox .= '</select>';
					break;
	
				case 'radio':

					$linkinfo["$fieldname"] = htmlspecialchars($linkinfo["$fieldname"]);

					foreach ($field['options'] AS $key => $option)
					{
						$option = trim($option);
						$inputbox .= '<label for="' . $fieldid . '_' . $key . '"><input id="' . $fieldid . '_' . $key . '" name="' . $fieldid . '" ' . iif($linkinfo["$fieldname"] == $option, 'checked="checked"') . ' type="radio" value="' . $option . '">' . $option . '</label>';
					}
					break;
	
				case 'checkbox':
	
					if (!is_array($linkinfo["$fieldname"]) AND !$editing)
					{
						$linkinfo["$fieldname"] = array();
					}
					if ($editing)
					{
						$linkinfo["$fieldname"] = explode(', ', $linkinfo["$fieldname"]);
					}

					$optarray = array();
					foreach ($linkinfo["$fieldname"] AS $okey => $ovalue)
					{
						$optarray[] = htmlspecialchars($ovalue);
					}
	
					foreach ($field['options'] AS $key => $option)
					{
						$option = trim($option);
						$inputbox .= '<label for="' . $fieldid . '_' . $key . '"><input id="' . $fieldid . '_' . $key . '" name="' . $fieldid . '[]" ' . iif(in_array($option, $optarray), 'checked="checked"') . ' type="checkbox" value="' . $option . '">' . $option . '</label><br />'; 
					}
					break;
	
				default:
					$inputbox = '<input class="bginput" name="' . $fieldid . '" size="35" value="' . htmlspecialchars($linkinfo["$fieldname"]) . '" />';
					
			}
	
			if ($admin)
			{
				print_label_row($field['title'], $inputbox);
			}
			else
			{
				eval('$cfbits .= "' . fetch_template('adv_links_addlink_custombits') . '";');
			}
			unset($inputbox);
		}
	}
	return $cfbits;
}

// ######################## Sort custom fields to insert into the db ####################
function construct_customfields_sql($linkid, $add = true, $makearray = false)
{
	global $DB_site, $_POST;

	$cfields = array();
	$customfields = $DB_site->query("SELECT * FROM " . TABLE_PREFIX . "links_customfields");
	while ($custom = $DB_site->fetch_array($customfields))
	{
		$cfields[$custom[fieldid]] = $custom;
	}

	if ($cfields)
	{
		foreach ($cfields AS $field => $values)
		{
			$thisfield = 'field' . $field;

			if ($makearray)
			{
				$fieldname = $_POST[$thisfield][$linkid];
			}
			else
			{
				$fieldname = $_POST["$thisfield"];
			}
			if (strlen($fieldname) > $values['maxlength'] AND $values['maxlength'])
			{
				$fieldname = substr($fieldname, 0, $values['maxlength']);
			}

			if (is_array($fieldname))
			{
				$fieldname = implode(', ', $fieldname);
			}

			if ($add)
			{
				$insert['fields'] .= ',' . $thisfield;
				$insert['values'] .= ', \'' . addslashes($fieldname) . '\'';
			}
			else
			{
				
				$insert['fields'] .= ', ' . $thisfield . ' = \'' . addslashes($fieldname) . '\'';
			}
		}
	}

	if (!empty($insert))
	{
		if ($add)
		{
			$DB_site->query("INSERT INTO " . TABLE_PREFIX . "links_customfields_entries (lid $insert[fields]) VALUES ($linkid $insert[values])");
		}
		else
		{
			$insert['fields'] = substr($insert['fields'], 1);
			$DB_site->query("UPDATE " . TABLE_PREFIX . "links_customfields_entries SET $insert[fields] WHERE lid = '$linkid'");
		}
	}
}	


// ###################### Directory Options #######################
function construct_dir_opts($dirid, $dirint)
{
	global $directoryopts, $datastore;

	foreach ($directoryopts AS $option => $value)
	{
		$diropts[$option] = 0;
		if($dirint & $value)
		{
			$diropts[$option] = 1;
		}
	}
	return $diropts;
}

// ############################# Subscribed Posts #########################
function send_subscribed_posts($linkid, $moderation = false, $userid = '', $username = '', $message = '')
{
	global $DB_site, $vba_options, $bbuserinfo, $vboptions, $post;

	if ($vba_options['links_allowsubscribe'])
	{
		$link = $DB_site->query_first("
				SELECT links.linkid, name, posts.dateline, categories.title
				FROM " . TABLE_PREFIX . "links_posts AS posts
				INNER JOIN " . TABLE_PREFIX . "links AS links USING (linkid)
				INNER JOIN " . TABLE_PREFIX . "links_categories AS categories USING (catid)
				WHERE links.linkid = '$linkid' ORDER BY dateline DESC LIMIT 1
		");

		if (!$moderation)
		{
			$userid = $bbuserinfo['userid'];
		}
		else
		{
			$post['message'] = $message;
			$bbuserinfo['username'] = $username;
		}

		$linkname = stripslashes($link['name']);
		$directoryname = stripslashes($link['title']);

		$subscriptions = $DB_site->query("
				SELECT subscriptions.userid, username, email
				FROM " . TABLE_PREFIX . "links_subscribelink AS subscriptions
				INNER JOIN " . TABLE_PREFIX . "user AS user USING (userid)
				WHERE linkid = '$linkid' AND user.lastactivity > '$link[dateline]' AND subscriptions.userid != '$userid'
		");
		while ($subscription = $DB_site->fetch_array($subscriptions))
		{
			eval(fetch_email_phrases('adv_links_subscribe_link', 0));
			vbmail($subscription['email'], $subject, $message);
		}
	}
}

// ######################## Function to Validate New Links ########################
function validate_new_links($validatelink)
{
	global $DB_site, $vba_options, $vboptions, $email, $dateline, $username, $userid, $name, $desc, $linkurl, $catid, $keywords, $views, $sendmail, $validatelink, $notes;

	if (is_array($validatelink))
	{
		foreach ($validatelink AS $key => $val)
		{
			if ($validatelink["$key"] == 2)
			{
				delete_links($key);

				if ($sendmail["$key"] AND !empty($email["$key"]))
				{
					$username = $username["$key"];
					$linktitle = $name["$key"];
					$linkid = $key;
					$hometitle = $vboptions['hometitle'];
					$linksurl = $vba_options['links_homeurl'];

					eval(fetch_email_phrases('adv_links_deletion', 0));
					
					vbmail($email["$key"], $subject, $message);
				}
			}
			if ($validatelink["$key"] == 1)
			{
				$DB_site->query("UPDATE " . TABLE_PREFIX . "links SET name = '" . addslashes(htmlspecialchars($name["$key"])) . "', description = '" . addslashes(htmlspecialchars($desc["$key"])) . "', url = '" . addslashes(htmlspecialchars($linkurl["$key"])) . "', keywords = '" . addslashes(htmlspecialchars($keywords["$key"])) . "', views = '$views[$key]', catid = '$catid[$key]', notes = '" . addslashes($notes["$key"]) . "', valid = 1 WHERE linkid = '$key'");

				construct_customfields_sql($key, false, true);

				if ($sendmail["$key"] AND !empty($email["$key"]))
				{
					$username = $username["$key"];
					$linktitle = $name["$key"];
					$linkid = $key;
					$hometitle = $vboptions['hometitle'];
					$linksurl = $vba_options['links_homeurl'];

					eval(fetch_email_phrases('adv_links_validation', 0));
					
					vbmail($email["$key"], $subject, $message);
				}

				$cat = $DB_site->query_first("SELECT lastupdated FROM " . TABLE_PREFIX . "links_categories WHERE catid = '$catid[$key]'");

				if ($dateline[$key] > $cat['lastupdated'])
				{
					$extrafields = ", lastlinkid = '$key', lastposter = '" . addslashes($username["$key"]) . "', lastlinktitle = '" . addslashes(htmlspecialchars($name["$key"])) . "', lastuserid = '$userid[$key]', lastupdated = '$dateline[$key]'";
				}

				$DB_site->query("UPDATE " . TABLE_PREFIX . "links_categories SET linkcount = linkcount+1 $extrafields WHERE catid = '$catid[$key]'");

			}
		}
	}
}

// ####################### Validate New Posts ######################
function validate_new_posts()
{
	global $DB_site, $vba_options, $title, $message, $validatepost, $catid, $linkid, $userid, $username, $dateline;

	if (is_array($validatepost))
	{
		foreach ($validatepost AS $key => $val)
		{
			if ($validatepost[$key] == 2)
			{
				$DB_site->query("DELETE FROM " . TABLE_PREFIX . "links_posts WHERE postid = '$key'");

			}
			if ($validatepost[$key] == 1)
			{

				$DB_site->query("UPDATE " . TABLE_PREFIX . "links_posts SET title = '" . addslashes(htmlspecialchars($title[$key])) . "', pagetext = '" . addslashes($message[$key]) . "', visible = '1' WHERE postid = '$key'");

				// Update link info
				$link = $DB_site->query_first("SELECT lastpostdateline FROM " . TABLE_PREFIX . "links WHERE linkid = '$linkid[$key]'");
				if ($link['lastpostdateline'] < $dateline[$key])
				{
					$DB_site->query("UPDATE " . TABLE_PREFIX . "links SET posts = posts+1, lastpostuserid = '$userid[$key]', lastpostusername = '" . addslashes($username[$key]) . "', lastpostdateline = '$dateline[$key]' WHERE linkid = '$linkid[$key]'");
				}		

				// Send email to subscribed users
				send_subscribed_posts($linkid["$key"], true, $userid["$key"], $username["$key"], $message["$key"]);

				// Update directory info
				$DB_site->query("UPDATE " . TABLE_PREFIX . "links_categories SET postcount = postcount+1 WHERE catid = '$catid[$key]'");
		
				// Update user post counts
				if ($vba_options['links_update_postcount'])
				{
					$DB_site->query("UPDATE " . TABLE_PREFIX . "user SET posts = posts+1 WHERE userid = '$userid[$key]'");
				}
			}
		}
	}
}
	
?>